/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar;

import com.eed3si9n.jarjar.PackageRemapper;
import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.JarProcessor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;

class ResourceProcessor
implements JarProcessor {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private PackageRemapper pr;

    public ResourceProcessor(PackageRemapper packageRemapper) {
        this.pr = packageRemapper;
    }

    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        switch (this.identify(entryStruct)) {
            case CLASS_FILE: {
                break;
            }
            case SERVICE_PROVIDER_CONFIGURATION: {
                entryStruct.name = this.remapService(entryStruct.name);
                entryStruct.data = this.remapServiceProviders(entryStruct.data);
                break;
            }
            case OTHER: {
                entryStruct.name = this.pr.mapPath(entryStruct.name);
            }
        }
        return true;
    }

    private String remapService(String string) {
        int n = string.lastIndexOf(47);
        return META_INF_SERVICES + this.pr.mapValue(string.substring(n + 1));
    }

    private byte[] remapServiceProviders(byte[] byArray) {
        String string2 = new String(byArray, StandardCharsets.UTF_8);
        String string3 = Arrays.stream(string2.split(System.lineSeparator())).map(string -> (String)this.pr.mapValue(Arrays.stream(string.split("#")).findFirst().orElse("").trim())).collect(Collectors.joining(System.lineSeparator()));
        return string3.getBytes(StandardCharsets.UTF_8);
    }

    private Resource identify(EntryStruct entryStruct) {
        if (entryStruct.name.endsWith(".class")) {
            return Resource.CLASS_FILE;
        }
        if (entryStruct.name.startsWith(META_INF_SERVICES) && !entryStruct.name.equals(META_INF_SERVICES)) {
            return Resource.SERVICE_PROVIDER_CONFIGURATION;
        }
        return Resource.OTHER;
    }

    private static enum Resource {
        CLASS_FILE,
        SERVICE_PROVIDER_CONFIGURATION,
        OTHER;

    }
}

