/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.netbeans.installer.downloader.DownloadManager;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.utils.DateUtils;
import org.netbeans.installer.utils.EngineUtils;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.UiUtils;
import org.netbeans.installer.utils.cli.CLIHandler;
import org.netbeans.installer.utils.helper.FinishHandler;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.wizard.Wizard;

public class Installer
implements FinishHandler {
    private static Installer instance;
    private File localDirectory = null;
    public static final int NORMAL_ERRORCODE = 0;
    public static final int CANCEL_ERRORCODE = 1;
    public static final int CRITICAL_ERRORCODE = 255;
    public static final String LOCK_FILE_NAME = ".nbilock";
    public static final String IGNORE_LOCK_FILE_PROPERTY = "nbi.ignore.lock.file";
    public static final String DEFAULT_LOCAL_DIRECTORY_PATH;
    public static final String LOCAL_DIRECTORY_PATH_PROPERTY = "nbi.local.directory.path";
    public static final String DONT_USE_SYSTEM_EXIT_PROPERTY = "nbi.dont.use.system.exit";
    public static final String EXIT_CODE_PROPERTY = "nbi.exit.code";
    public static final String BUNDLE_PROPERTIES_FILE_PROPERTY = "nbi.bundle.properties.file";
    public static final String LOG_FILE_NAME;
    private static final String ERROR_UNSUPPORTED_PLATFORM_KEY = "I.error.unsupported.platform";
    private static final String WARNING_SILENT_WITHOUT_STATE_KEY = "I.warning.silent.without.state";
    private static final String ERROR_CANNOT_CREATE_LOCAL_DIR_KEY = "I.error.cannot.create.local.dir";
    private static final String ERROR_LOCAL_DIR_IS_FILE_KEY = "I.error.local.dir.is.file";
    private static final String ERROR_NO_READ_PERMISSIONS_FOR_LOCAL_DIR_KEY = "I.error.no.read.permissions.for.local.dir";
    private static final String ERROR_NO_WRITE_PERMISSIONS_FOR_LOCAL_DIR_KEY = "I.error.no.write.permissions.for.local.dir";
    private static final String LOCK_FILE_EXISTS_DIALOG_TITLE_KEY = "I.lock.file.exists.dialog.title";
    private static final String LOCK_FILE_EXISTS_DIALOG_TEXT_KEY = "I.lock.file.exists.dialog.text";
    private static final String ERROR_CANNOT_CREATE_LOCK_FILE_KEY = "I.error.cannot.create.lock.file";

    public static void main(String[] arguments) {
        new Installer(arguments).start();
    }

    public static synchronized Installer getInstance() {
        if (instance == null) {
            instance = new Installer(new String[0]);
        }
        return instance;
    }

    private Installer(String[] arguments) {
        LogManager.logEntry("initializing the installer engine");
        this.initializeErrorHandler();
        this.dumpSystemInfo();
        EngineUtils.checkEngine();
        this.initializePlatform();
        instance = this;
        this.parseArguments(arguments);
        this.loadEngineProperties();
        this.initializeLocalDirectory();
        this.initializeLogManager();
        this.initializeDownloadManager();
        this.initializeRegistry();
        this.initializeWizard();
        this.createLockFile();
        LogManager.logExit("... finished initializing the engine");
    }

    public void start() {
        LogManager.logEntry("starting the installer");
        Wizard.getInstance().open();
        LogManager.logExit("... finished starting the installer");
    }

    @Override
    public void cancel() {
        this.exitNormally(1);
    }

    @Override
    public void finish() {
        int exitCode = 0;
        Object prop = System.getProperties().get(EXIT_CODE_PROPERTY);
        if (prop instanceof Integer) {
            try {
                exitCode = (Integer)prop;
            }
            catch (NumberFormatException e) {
                LogManager.log("... cannot parse exit code : " + prop, (Throwable)e);
            }
        }
        this.exitNormally(exitCode);
    }

    @Override
    public void criticalExit() {
        LogManager.stop();
        this.exitImmediately(255);
    }

    public File getLocalDirectory() {
        if (this.localDirectory == null) {
            this.initializeLocalDirectory();
        }
        return this.localDirectory;
    }

    private void initializeErrorHandler() {
        LogManager.logEntry("... initializing ErrorHandler");
        ErrorManager.setFinishHandler(this);
        ErrorManager.setExceptionHandler(new ErrorManager.ExceptionHandler());
        Thread.currentThread().setUncaughtExceptionHandler(ErrorManager.getExceptionHandler());
        LogManager.logExit("... end of ErrorHandler initialization");
    }

    private void initializePlatform() {
        if (SystemUtils.getCurrentPlatform() == null) {
            ErrorManager.notifyCritical(ResourceUtils.getString(Installer.class, ERROR_UNSUPPORTED_PLATFORM_KEY));
        }
    }

    private void initializeLogManager() {
        String logFileProp = System.getProperty("nbi.utils.log.file");
        File logFile = logFileProp == null ? new File(this.getLocalDirectory(), LOG_FILE_NAME) : new File(logFileProp).getAbsoluteFile();
        LogManager.setLogFile(logFile);
        LogManager.start();
    }

    private void initializeDownloadManager() {
        LogManager.logEntry("... initializing DownloadManager");
        DownloadManager downloadManager = DownloadManager.getInstance();
        downloadManager.setLocalDirectory(this.getLocalDirectory());
        downloadManager.setFinishHandler(this);
        downloadManager.init();
        LogManager.logExit("... end of initializing DownloadManager");
    }

    private void initializeRegistry() {
        LogManager.logEntry("... initializing Registry");
        Registry registry = Registry.getInstance();
        registry.setLocalDirectory(this.getLocalDirectory());
        registry.setFinishHandler(this);
        LogManager.logExit("... end of initializing ErrorHandler");
    }

    private void initializeWizard() {
        LogManager.logEntry("... initializing Wizard");
        Wizard wizard = Wizard.getInstance();
        wizard.setFinishHandler(this);
        wizard.getContext().put(Registry.getInstance());
        LogManager.logExit("... end of initializing Wizard");
    }

    private void exitNormally(int errorCode) {
        Wizard.getInstance().close();
        DownloadManager.getInstance().terminate();
        LogManager.stop();
        this.exitImmediately(errorCode);
    }

    private void exitImmediately(int errorCode) {
        if (Boolean.getBoolean(DONT_USE_SYSTEM_EXIT_PROPERTY) && errorCode != 255) {
            System.getProperties().put(EXIT_CODE_PROPERTY, (Object)errorCode);
        } else {
            System.exit(errorCode);
        }
    }

    private void dumpSystemInfo() {
        LogManager.logEntry("dumping target system information");
        LogManager.logIndent("system properties:");
        for (Object key : new TreeSet<Object>(System.getProperties().keySet())) {
            LogManager.log(key.toString() + " => " + System.getProperties().get(key).toString());
        }
        LogManager.unindent();
        LogManager.logExit("... end of target system information");
    }

    private void loadEngineProperties() {
        LogManager.logEntry("loading engine properties");
        try {
            LogManager.logIndent("loading engine properties");
            ResourceBundle bundle = ResourceBundle.getBundle("data.engine");
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = bundle.getString(key);
                LogManager.log("loading " + key + " => " + value);
                String currentValue = System.getProperty(key);
                if (currentValue != null) {
                    LogManager.log("... already defined, using existing value: " + currentValue);
                    continue;
                }
                System.setProperty(key, value);
            }
        }
        catch (MissingResourceException e) {
            LogManager.log("... no engine properties file, skip loading engine properties");
        }
        LogManager.unindent();
        LogManager.logExit("... finished loading engine properties");
    }

    private void parseArguments(String[] arguments) {
        LogManager.logEntry("parsing command-line arguments");
        new CLIHandler(arguments).proceed();
        LogManager.logExit("... finished parsing command line arguments");
    }

    private void initializeLocalDirectory() {
        if (this.localDirectory != null) {
            return;
        }
        LogManager.logIndent("initializing the local directory");
        if (System.getProperty(LOCAL_DIRECTORY_PATH_PROPERTY) != null) {
            String path = System.getProperty(LOCAL_DIRECTORY_PATH_PROPERTY);
            LogManager.log("... local directory path (initial) : " + path);
            path = SystemUtils.resolveString(path);
            LogManager.log("... local directory path (resolved): " + path);
            this.localDirectory = new File(path).getAbsoluteFile();
        } else {
            LogManager.log("... custom local directory was not specified, using the default");
            this.localDirectory = new File(DEFAULT_LOCAL_DIRECTORY_PATH).getAbsoluteFile();
            System.setProperty(LOCAL_DIRECTORY_PATH_PROPERTY, this.localDirectory.getAbsolutePath());
        }
        LogManager.log("... local directory: " + this.localDirectory);
        if (!this.localDirectory.exists()) {
            if (!this.localDirectory.mkdirs()) {
                ErrorManager.notifyCritical(ResourceUtils.getString(Installer.class, ERROR_CANNOT_CREATE_LOCAL_DIR_KEY, this.localDirectory));
            }
        } else if (this.localDirectory.isFile()) {
            ErrorManager.notifyCritical(ResourceUtils.getString(Installer.class, ERROR_LOCAL_DIR_IS_FILE_KEY, this.localDirectory));
        } else if (!this.localDirectory.canRead()) {
            ErrorManager.notifyCritical(ResourceUtils.getString(Installer.class, ERROR_NO_READ_PERMISSIONS_FOR_LOCAL_DIR_KEY, this.localDirectory));
        } else if (!this.localDirectory.canWrite()) {
            ErrorManager.notifyCritical(ResourceUtils.getString(Installer.class, ERROR_NO_WRITE_PERMISSIONS_FOR_LOCAL_DIR_KEY, this.localDirectory));
        }
        LogManager.logUnindent("... finished initializing local directory");
    }

    private void createLockFile() {
        LogManager.logIndent("creating lock file");
        if (System.getProperty(IGNORE_LOCK_FILE_PROPERTY) == null) {
            File lock = new File(this.getLocalDirectory(), LOCK_FILE_NAME);
            if (lock.exists()) {
                LogManager.log("... lock file already exists at " + lock);
                LogManager.log("... to skip lock file check run installer with --ignore-lock argument");
                String dialogTitle = ResourceUtils.getString(Installer.class, LOCK_FILE_EXISTS_DIALOG_TITLE_KEY);
                String dialogText = ResourceUtils.getString(Installer.class, LOCK_FILE_EXISTS_DIALOG_TEXT_KEY, lock.getAbsolutePath());
                if (!UiUtils.showYesNoDialog(dialogTitle, dialogText)) {
                    this.cancel();
                }
            } else {
                try {
                    lock.createNewFile();
                }
                catch (IOException e) {
                    ErrorManager.notifyCritical(ResourceUtils.getString(Installer.class, ERROR_CANNOT_CREATE_LOCK_FILE_KEY), e);
                }
                LogManager.log("... created lock file: " + lock);
            }
            lock.deleteOnExit();
        } else {
            LogManager.log("... running with --ignore-lock, skipping this step");
        }
        LogManager.logUnindent("finished creating lock file");
    }

    @Deprecated
    public File cacheInstallerEngine(Progress progress) throws IOException {
        return EngineUtils.cacheEngine(progress);
    }

    static {
        DEFAULT_LOCAL_DIRECTORY_PATH = System.getProperty("user.home") + File.separator + ".nbi";
        LOG_FILE_NAME = "log/" + DateUtils.getTimestamp() + ".log";
    }
}

