/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends SystemFunction
implements Callable {
    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        if (arguments[0] instanceof StringLiteral && visitor.getTargetEdition().equals(visitor.getConfiguration().getEditionCode())) {
            try {
                String local;
                String name = ((StringLiteral)arguments[0]).stringify();
                StructuredQName qName = StructuredQName.fromLexicalQName(name, false, true, this.getRetainedStaticContext());
                if (qName.hasURI(NamespaceUri.XSLT) && ((local = qName.getLocalPart()).equals("version") || local.equals("vendor") || local.equals("vendor-url") || local.equals("product-name") || local.equals("product-version") || local.equals("supports-backwards-compatibility") || local.equals("xpath-version") || local.equals("xsd-version"))) {
                    String result = SystemProperty.getProperty("http://www.w3.org/1999/XSL/Transform", local, this.getRetainedStaticContext());
                    return new StringLiteral(result);
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        String name = arguments[0].head().getStringValue();
        try {
            StructuredQName qName = StructuredQName.fromLexicalQName(name, false, true, this.getRetainedStaticContext());
            return new StringValue(SystemProperty.getProperty(qName.getNamespaceUri().toString(), qName.getLocalPart(), this.getRetainedStaticContext()));
        }
        catch (XPathException err) {
            throw new XPathException("Invalid system property name. " + err.getMessage(), "XTDE1390", context);
        }
    }

    public static String yesOrNo(boolean whatever) {
        return whatever ? "yes" : "no";
    }

    public static String getProperty(String uri, String local, RetainedStaticContext rsc) {
        Configuration config = rsc.getConfiguration();
        String edition = rsc.getPackageData().getTargetEdition();
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            switch (local) {
                case "version": {
                    return "3.0";
                }
                case "vendor": {
                    return Version.getProductVendor();
                }
                case "vendor-url": {
                    return Version.getWebSiteAddress();
                }
                case "product-name": {
                    return Version.getProductName();
                }
                case "product-version": {
                    return Version.getProductVariantAndVersion(edition);
                }
                case "is-schema-aware": {
                    boolean schemaAware = rsc.getPackageData().isSchemaAware();
                    return SystemProperty.yesOrNo(schemaAware);
                }
                case "supports-serialization": {
                    return "yes";
                }
                case "supports-backwards-compatibility": {
                    return "yes";
                }
                case "supports-namespace-axis": {
                    return "yes";
                }
                case "supports-streaming": {
                    return SystemProperty.yesOrNo("EE".equals(edition) && config.isLicensedFeature(2) && !config.getConfigurationProperty(Feature.STREAMABILITY).equals("off"));
                }
                case "supports-dynamic-evaluation": {
                    return SystemProperty.yesOrNo(!config.getBooleanProperty(Feature.DISABLE_XSL_EVALUATE));
                }
                case "supports-higher-order-functions": {
                    return "yes";
                }
                case "xpath-version": {
                    return "3.1";
                }
                case "xsd-version": {
                    return rsc.getConfiguration().getXsdVersion() == 10 ? "1.0" : "1.1";
                }
            }
            return "";
        }
        if (uri.isEmpty() && config.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
            String val = System.getProperty(local);
            return val == null ? "" : val;
        }
        return "";
    }
}

