{$N-,E-}

unit BibMouse;

interface

uses 
        dos,bibcrt;

const
        MOUSEINT = $33; {mouse driver interrupt}

type
        mouseType = (twoButton,threeButton,another);
        MouseCursorType = record
          Hardware: boolean;
          hfirst,hlast: byte;
        end;
        buttonState = (buttonDown,buttonUp);
var
        mouse_present, UseMouse, OrigUseMouse, SoftwareMouseReset : boolean;
        Mouse_initialized: boolean;
        XMotions,YMotions : word;          {per 8 pixels}
        MouseCursorLevel : integer;
        MouseCursor: MouseCursorType;

        {if > 0 mouse cursor is visible, otherwise not, containes the level
         of showMouseCursor/hideMouseCursor}

const
    click_repeat  = 10; { Recommended value for WaitForRelease timeOut }

procedure InitMouse; {when replacing mouse mode do that..!}
procedure HardMouseReset;
procedure SoftMouseReset;
procedure ShowMouseCursor;
procedure HideMouseCursor;
function  GetMouseX : word;
function  GetMouseY : word;
function  GetButton(Button : Byte) : buttonState;
procedure GetMouseState(var Left,Right,Middle: boolean; var X,Y: byte);
function  ButtonPressed : boolean;
procedure SetMouseCursor(x,y : word);
procedure MouseBox(left,top,right,bottom : word); {limit mouse rectangle}
procedure HardwareTextCursor(fromLine,toLine : word);
procedure WaitForRelease(timeOut : word);
procedure InterceptMouse; { get mouse from interrupted program, and stop it .. }
procedure RestoreMouse;


implementation

{$ifdef ver60}
const
   seg0040 = $40; { needed - in Ver7.0 points to bios area, 
                             needed so protected mode will not crash on
                             RT-error 216 (exception 13 }
{$endif}   

type box = record
                left,top,right,bottom : word;
        end; {Do not change field order !!!}

var 
   reg : registers;  {general registers used}
   interceptX, 
   interceptY : word;

function InitAsm(which: word): boolean; assembler;
asm
  mov ax, which
  mov bx, 0
  Int $33
  cmp ax, 0
  je @NotExists
  mov al, 1
@NotExists:
end;

procedure SetSensitivity(x,y: word); assembler;
asm
  mov ax, $1A
  mov bx, X
  mov CX, Y
  Int $33
end;

function XPosAsm: word; assembler;
asm
  mov ax, 3
  Int $33
  mov ax, cx
end;

function YPosAsm: word; assembler;
asm
  mov ax, 3
  Int $33
  mov ax, dx
end;

function WhichButton: word; assembler;
asm
  mov ax, 3
  Int $33
  mov ax, bx
end;

(******************************************************************************
*                                  initMouse                                  *
******************************************************************************)
procedure InitMouse;
begin
  if SoftwareMouseReset then mouse_present:=InitAsm($21)
  else Mouse_Present:=InitAsm(0);
  if (Xmotions>0) and (Ymotions>0) then SetSensitivity(Xmotions,Ymotions);
  mouseCursorLevel := 0; { not visible, one show to appear }
  Mouse_Initialized:=true;
end; {initMouse}

procedure HardMouseReset; assembler;
asm
  mov ax, 0
  mov bx, 0
  Int $33
end;

procedure SoftMouseReset; assembler;
asm
  mov ax, $21
  mov bx, 0
  Int $33
end;

(******************************************************************************
*                               showMouseCursor                               *
******************************************************************************)
procedure ShowMouseCursor;
begin
  if not (mouse_present and UseMouse) then exit;
  asm
    mov ax, 1
    int $33
  end;
  if MouseCursor.hardware then setcursor(MouseCursor.hfirst,MouseCursor.hlast);
  inc(mouseCursorLevel);
end; {showMouseCursor}

(******************************************************************************
*                               hideMouseCursor                               *
******************************************************************************)
procedure HideMouseCursor;
begin
  if not (mouse_present and UseMouse) then exit;
  if MouseCursor.hardware then setcursor(32,32);
  asm
    mov ax, 2
    int $33
  end;
  dec(mouseCursorLevel);
end; {hideMouseCursor}

(******************************************************************************
*                                  getMouseX                                  *
******************************************************************************)
function getMouseX : word;
begin
  if not (mouse_present and UseMouse) then getMouseX:=0
  else getMouseX:=XPosAsm;
end; {getMouseX}

(******************************************************************************
*                                  getMouseY                                  *
******************************************************************************)
function getMouseY : word;
begin
  if not (mouse_present and UseMouse) then getMouseY:=0
  else getMouseY:=YPosAsm;
end; {getMouseX}

(******************************************************************************
*                                  getButton                                  *
******************************************************************************)
function getButton(Button : Byte) : buttonState;
var
  state: word;
begin
  if not (mouse_present and UseMouse) then
    getButton:=buttonUp
  else begin
    State:=WhichButton;
    if (state AND button)<>0 then getButton:=ButtonDown
    {
    reg.ax := 3;
    intr(MouseInt,reg);
    if ((reg.bx and Button) <> 0) then
      getButton := buttonDown
    }
    else getButton := buttonUp;
  end;
end; {getButton}

procedure GetMouseState(var Left,Right,Middle: boolean; var X,Y: byte);
var
  bxreg,cxreg,dxreg: word;
begin
  Left:=false; Right:=false; Middle:=false; X:=0; Y:=0;
  if mouse_present and UseMouse then
  begin
    asm
      mov ax, 3
      int $33
      mov bxreg, bx
      mov cxreg, cx
      mov dxreg, dx
    end;
    if ((bxreg and 1) <> 0) then Left:=true;
    if ((bxreg and 2) <> 0) then Right:=true;
    if ((bxreg and 4) <> 0) then Middle:=true;
    X:=(cxreg div xpixels)+1;
    Y:=(dxreg div ypixels)+1;
  end;
end;

procedure GetMouseState1(var Left,Right,Middle: boolean; var X,Y: byte);
begin
  Left:=false; Right:=false; Middle:=false; X:=0; Y:=0;
  if mouse_present and UseMouse then
  begin
    reg.ax := 3;
    intr(MouseInt,reg);
    if ((reg.bx and 1) <> 0) then Left:=true;
    if ((reg.bx and 2) <> 0) then Right:=true;
    if ((reg.bx and 4) <> 0) then Middle:=true;
    reg.ax := 3;
    intr(MouseInt,reg);
    X:=(reg.cx div xpixels)+1;
    Y:=(reg.dx div ypixels)+1;
  end;
end;

(******************************************************************************
*                                buttonPressed                                *
******************************************************************************)
function buttonPressed : boolean;
var
  bxreg: word;
begin
  if not (mouse_present and UseMouse) then
    buttonPressed:=false
  else begin
    asm
      mov ax, 3
      int $33
      mov bxreg, bx
    end;
    ButtonPressed:=((bxreg and 7) <> 0);
  end;
end; {buttonPressed}

function buttonPressed1 : boolean;
begin
  if not (mouse_present and UseMouse) then
    buttonPressed1:=false
  else begin
    reg.ax := 3;
    intr(MouseInt,reg);
    if ((reg.bx and 7) <> 0) then  buttonPressed1 := True
    else buttonPressed1 := False;
  end;
end; {buttonPressed}

(******************************************************************************
*                               setMouseCursor                                *
******************************************************************************)
procedure setMouseCursor(x,y : word);
begin
  if not (mouse_present and UseMouse) then Exit;
  asm
    mov ax, 4
    mov cx, x
    mov dx, y
    int $33
  end;
end; {setMouseCursor}

(******************************************************************************
*                                    swap                                     *
******************************************************************************)
procedure swap(var a,b : word);
var
  c : word;
begin
  c := a;
  a := b;
  b := c; {swap a and b}
end; {swap}

(******************************************************************************
*                                  mouseBox                                   *
******************************************************************************)
procedure mouseBox(left,top,right,bottom : word);
begin
  if not (mouse_present and UseMouse) then Exit;
  if (left > right) then swap(left,right);
  if (top > bottom) then swap(top,bottom); {make sure they are ordered}
  asm
    mov ax, 7
    mov cx, left
    mov dx, right
    int $33
    mov ax, 8
    mov cx, top
    mov dx, bottom
    int $33
  end;
  Exit;
  reg.ax := 7;
  reg.cx := left;
  reg.dx := right;
  intr(MouseInt,reg); {set x range}
  reg.ax := 8;
  reg.cx := top;
  reg.dx := bottom;
  intr(MouseInt,reg); {set y range}
end; {mouseBox}

(******************************************************************************
*                             HardwareTextCursor                              *
******************************************************************************)
procedure HardwareTextCursor(fromLine,toLine : word);
{set text cursor to text, using the scan lines from..to,
 same as intr 10 cursor set in bios :
 color scan lines 0..7, monochrome 0..13 }

begin
  if not (mouse_present and UseMouse) then Exit;
  asm
    mov ax, $A
    mov bx, 1
    mov cx, FromLine
    mov dx, ToLine
    Int $33
  end;
  {
  reg.ax := 10;
  reg.bx := 1;
  reg.cx := fromLine;
  reg.dx := toLine;
  intr(MouseInt,reg);
  }
  with MouseCursor do
  begin
    hardware:=true;
    hfirst:=fromLine;
    hlast:=toLine;
  end;
end; {hardwareTextCursor}


(******************************************************************************
*                               waitForRelease                                *
* Wait until button is release, or timeOut 1/100 seconds pass. (might miss a  *
* tenth (1/10) of a second.                                                   *
******************************************************************************)
procedure waitForRelease;
var
    sHour, sMinute, sSecond, sSec100 : word;    { Time at start }
    cHour, cMinute, cSecond, cSec100 : word;    { Current time  }
    stopSec                          : longInt;
    currentSec                       : longInt;
    Delta                            : longInt;
begin
  if not (mouse_present and UseMouse) then Exit;
  getTime(sHour, sMinute, sSecond, sSec100);
  stopSec := (sHour*36000 + sMinute*600 + sSecond*10 + sSec100 + timeOut) mod
                    (24*360000);
  repeat
          getTime(cHour, cMinute, cSecond, cSec100);
          currentSec := (cHour*36000 + cMinute*600 + cSecond*10 + cSec100);
          Delta := currentSec - stopSec; 
  until (not ButtonPressed) or (Delta >=0) and (Delta < 36000);
end; {waitForRelease}


(******************************************************************************
*                               interceptMouse                                *
******************************************************************************)
procedure interceptMouse;
begin
  if not (mouse_present and UseMouse) then Exit;
  with reg do begin
    ax := 3;
    intr(MouseInt,reg); { get place .. }
    interceptX := cx;
    interceptY := dx;
    ax := 31;
    intr(MouseInt,reg);
  end; { disable mouse driver .. }
end; {interceptMouse}

(******************************************************************************
*                                restoreMouse                                 *
******************************************************************************)
procedure RestoreMouse;
begin
  if not (mouse_present and UseMouse) then Exit;
  with reg do begin
    ax := 32; { restore mouse driver .. }
    intr(MouseInt,reg);
    ax := 4;
    cx := interceptX;
    dx := interceptY;
    intr(MouseInt,reg);
  end; { with .. }
end; {restoreMouse}

var
    OldExitProc : pointer;

(******************************************************************************
*                                 MyExitProc                                  *
******************************************************************************)
{$f+}
procedure MyExitProc;
begin
    ExitProc := OldExitProc;
    if Mouse_Present then initMouse;
end; { myExitProc }
{$f-}

{ if this unit is used with a graphic unit that is loaded and executed after
     this unit in the Uses clause, the mouse initialization will not be
     correct, be sure to call initMouse in your program start to work
     properly }

begin   {unit initialization}
  mouse_present:=false; UseMouse:=false; OrigUseMouse:=false;
  SoftwareMouseReset:=false;
  Mouse_Initialized:=false;
  Xmotions:=0; Ymotions:=0;
  with MouseCursor do
  begin
    hardware:=false;
    hfirst:=0;
    if IsMDA then hlast:=13
    else hlast:=7;
  end;
  OldExitProc := ExitProc;
  ExitProc := @MyExitProc;
end. 
